
-- @Author: Ragman2414
-- @Date: 02.12.2021
-- @Version: 1.0.0.0


ReduceMaintenance = {};
ReduceMaintenance.name = g_currentModName;
ReduceMaintenance.modDirectory = g_currentModDirectory
source(g_currentModDirectory .. "loadMaintenanceSettingsEvent.lua")
function ReduceMaintenance.init()

    Wearable.updateDamageAmount = Utils.overwrittenFunction(Wearable.updateDamageAmount, ReduceMaintenance.updateDamageAmount)
    Wearable.updateWearAmount = Utils.overwrittenFunction(Wearable.updateWearAmount, ReduceMaintenance.updateWearAmount)


    Mission00.loadMission00Finished = Utils.appendedFunction(Mission00.loadMission00Finished, ReduceMaintenance.loadSettingsXML)
    FSCareerMissionInfo.saveToXMLFile = Utils.appendedFunction(FSCareerMissionInfo.saveToXMLFile, ReduceMaintenance.saveSettingsXML)

    FSBaseMission.onConnectionFinishedLoading = Utils.appendedFunction(FSBaseMission.onConnectionFinishedLoading, ReduceMaintenance.loadSettingsFromServer2)

end

function ReduceMaintenance.registerOverwrittenFunctions(vehicleType)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "getRepairPrice", ReduceMaintenance.getRepairPrice);
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "getRepaintPrice", ReduceMaintenance.getRepaintPrice);
end

function ReduceMaintenance.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Wearable, specializations);
end;

function ReduceMaintenance:getRepairPrice(superFunc)
    return superFunc(self) * g_r_maintenance.maintenanceCost
end

function ReduceMaintenance:getRepaintPrice(superFunc)
    return superFunc(self) * g_r_maintenance.wearCost
end



function ReduceMaintenance.updateDamageAmount(wearable, superFunc, dt)
    return superFunc(wearable, dt * g_r_maintenance.maintenanceDuration);
end

function ReduceMaintenance.updateWearAmount(wearable, superFunc,value,dt)

    return superFunc(wearable,value,dt * g_r_maintenance.wearDuration);

end

function ReduceMaintenance.loadSettingsXML(mission, node)
    ReduceMaintenance.defaultValues();
    if mission:getIsServer() then
        if mission.missionInfo.savegameDirectory ~= nil and fileExists(mission.missionInfo.savegameDirectory .. "/r_maintenance.xml") then
            local xmlFile = XMLFile.load("RMaintenanceXML", mission.missionInfo.savegameDirectory .. "/r_maintenance.xml")
            if xmlFile ~= nil then
                g_r_maintenance.maintenanceCost = xmlFile:getFloat("r_maintenance.maintenanceCost")
                g_r_maintenance.maintenanceDuration = xmlFile:getFloat("r_maintenance.maintenanceDuration")
                g_r_maintenance.wearCost = xmlFile:getFloat("r_maintenance.wearCost")
                g_r_maintenance.wearDuration = xmlFile:getFloat("r_maintenance.wearDuration")
                xmlFile:delete()
            end
        end
    end
end

function ReduceMaintenance.loadSettingsFromServer2()
    g_client:getServerConnection():sendEvent(LoadMaintenanceSettingsEvent.new())

end

function ReduceMaintenance.defaultValues()
    if(g_r_maintenance == nil) then
        g_r_maintenance = {}
    end
    if(g_r_maintenance.maintenanceCost == nil or g_r_maintenance.maintenanceCost == 0) then
        g_r_maintenance.maintenanceCost = 1
    end

    if(g_r_maintenance.maintenanceDuration == nil or g_r_maintenance.maintenanceDuration == 0) then
        g_r_maintenance.maintenanceDuration = 1
    end

    if(g_r_maintenance.wearCost == nil or g_r_maintenance.wearCost == 0) then
        g_r_maintenance.wearCost = 1
    end

    if(g_r_maintenance.wearDuration == nil or g_r_maintenance.wearDuration == 0) then
        g_r_maintenance.wearDuration = 1
    end
end

function ReduceMaintenance.saveSettingsXML(missionInfo)
    if(g_r_maintenance == nil) then
        return
    end
    local xmlFile = XMLFile.create("RMaintenanceXML", missionInfo.savegameDirectory .. "/r_maintenance.xml", "r_maintenance")
    if xmlFile ~= nil then
        xmlFile:setFloat("r_maintenance.maintenanceCost", g_r_maintenance.maintenanceCost)
        xmlFile:setFloat("r_maintenance.maintenanceDuration",g_r_maintenance.maintenanceDuration)
        xmlFile:setFloat("r_maintenance.wearCost", g_r_maintenance.wearCost)
        xmlFile:setFloat("r_maintenance.wearDuration",g_r_maintenance.wearDuration)
        xmlFile:save()
    end

end

ReduceMaintenance.init()