--[[
    RotationModeEvent

    Multiplayer Sync Event for the RealGPS's Rotation Mode toggle.

	@author: 		BayernGamers
	@date: 			11.03.2025
	@version:		2.0

	History:		v1.0 @15.07.2023 - initial implementation in FS 22
                    ------------------------------------------------------------------------------------------------------
                    v2.0 @11.03.2025 - convert and re-write for FS25
                    ------------------------------------------------------------------------------------------------------
                    v2.2 @15.06.2025 - added support for multiple PDA's
                    -------------------------------------------------------------------------------------------------------
	
	License:        Terms:
                        Usage:
                            Feel free to use this work as-is as long as you adhere to the following terms:
						Attribution:
							You must give appropriate credit to the original author when using this work.
						No Derivatives:
							You may not alter, transform, or build upon this work in any way.
						Usage: 
							The work may be used for personal and commercial purposes, provided it is not modified or adapted.
						Additional Clause:
							This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.
]]
RotationModeEvent = {}

local RotationModeEvent_mt = Class(RotationModeEvent, Event)

InitEventClass(RotationModeEvent, "RotationModeEvent")

function RotationModeEvent:emptyNew()
    local self = Event.new(RotationModeEvent_mt)
    return self
end

function RotationModeEvent.new(vehicle, mapId, active)
    local self = RotationModeEvent:emptyNew()
    self.vehicle = vehicle
    self.mapId = mapId
    self.active = active

    return self
end

function RotationModeEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.vehicle)
    streamWriteInt8(streamId, self.mapId)
    streamWriteBool(streamId, self.active)
end

function RotationModeEvent:readStream(streamId, connection)
    self.vehicle = NetworkUtil.readNodeObject(streamId)
    self.mapId = streamReadInt8(streamId)
    self.active = streamReadBool(streamId)
    self:run(connection)
end

function RotationModeEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.vehicle)
    end
    if self.vehicle ~= nil then
        for i, map in ipairs(self.vehicle.spec_realGPS.maps) do
            if i == self.mapId then
                self.vehicle:setRotateMap(map, self.active)
                RealGPS.updateActionEvents(self.vehicle)
            end
        end
    end
end

function RotationModeEvent.sendEvent(vehicle, mapId, active, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(RotationModeEvent.new(vehicle, mapId, active), nil, nil, vehicle)
        else
            g_client:getServerConnection():sendEvent(RotationModeEvent.new(vehicle, mapId, active))
        end
    end
end